/*!\file InputUpdateFromDakotax
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromDakotax.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"

void  InputUpdateFromDakotax(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials*  materials,Parameters* parameters,double* variables,char* *variables_descriptors,int numvariables){

	int     i,j,k;
	int     dummy;
	
	int     numberofvertices;
	int     qmu_npart;
	double *qmu_part  = NULL;

	double* distributed_values=NULL;
	double* parameter=NULL;
	char*   descriptor=NULL;
	char    root[50]; //root name of variable, ex: DragCoefficent, RhoIce, etc ...

	/*retrieve parameters: */
	parameters->FindParam(&qmu_npart,QmuNPartEnum);
	parameters->FindParam(&qmu_part,&dummy,QmuPartEnum);
	numberofvertices=vertices->NumberOfVertices();

	/*Go through all dakota descriptors, ex: "rho_ice","thermal_conductivity","thickness1","thickness2", etc ..., and 
	 * for each descriptor, take the variable value and plug it into the inputs: */

	for(i=0;i<numvariables;i++){
	
		descriptor=variables_descriptors[i];

		/*From descriptor, figure out if the variable is scaled, indexed, nodal, or just a simple variable: */
		if (strncmp(descriptor,"scaled_",7)==0){
			
			/*Variable is scaled. Determine root name of variable (ex: scaled_DragCoefficient_1 -> DragCoefficient). Allocate distributed_values and fill the 
			 * distributed_values with the next qmu_npart variables: */
			
			//memcpy(root,strstr(descriptor,"_")+1,(strlen(strstr(descriptor,"_")+1)+1)*sizeof(char));
			strcpy(root,strstr(descriptor,"_")+1); *strstr(root,"_")='\0';
			*strstr(root,"_")='\0';


			distributed_values=(double*)xmalloc(qmu_npart*sizeof(double));
			for(j=0;j<qmu_npart;j++){
				distributed_values[j]=variables[i+j];
			}

			/*Now, pick up the parameter corresponding to root: */
			parameters->FindParam(&parameter,NULL,StringToEnumx(root));

			/*We've got the parameter, we need to update it using qmu_part (a partitioning vector), and the distributed_values: */
			for(k=0;k<numberofvertices;k++){
				parameter[k]=parameter[k]*distributed_values[(int)qmu_part[k]];
			}

			#ifdef _DEBUG_
				PetscSynchronizedPrintf(MPI_COMM_WORLD,"Parameter vector:");
				PetscSynchronizedFlush(MPI_COMM_WORLD);
				for(k=0;k<numberofvertices;k++){
					PetscSynchronizedPrintf(MPI_COMM_WORLD," node %i value %g\n",k+1,parameter[k]);
					PetscSynchronizedFlush(MPI_COMM_WORLD);
				}
				PetscSynchronizedPrintf(MPI_COMM_WORLD," descriptor: %s root %s enum: %i\n",descriptor,root,StringToEnumx(root));
				PetscSynchronizedFlush(MPI_COMM_WORLD);
			#endif
			  

			/*Update inputs using the parameter vector: */
			InputUpdateFromVectorDakotax( elements,nodes, vertices,loads, materials,  parameters, parameter, StringToEnumx(root), VertexEnum);

			/*increment i to skip the distributed values just collected: */
			i+=qmu_npart-1; //careful, the for loop will add 1.

			/*Free allocations: */
			xfree((void**)&parameter);
			xfree((void**)&distributed_values);
		}
		else if (strncmp(descriptor,"indexed_",8)==0){
			_error_(" indexed variables not supported yet!");
		}
		else if (strncmp(descriptor,"nodal_",8)==0){
			_error_(" nodal variables not supported yet!");
		}
		else{
			/*Ok, standard variable, just update inputs using the variable: */
			InputUpdateFromConstantx( elements,nodes, vertices,loads, materials,  parameters, variables[i],StringToEnumx(descriptor));
		}
	}

	/*Free ressources:*/
	xfree((void**)&qmu_part);

}
