/*!\file OptionLogical.cpp
 * \brief: implementation of the optionslogical object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionLogical::OptionLogical(){{{1*/
OptionLogical::OptionLogical(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionLogical::~OptionLogical(){{{1*/
OptionLogical::~OptionLogical(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionLogical::Echo {{{1*/
void  OptionLogical::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionLogical Echo:\n");
	Option::Echo();

	if (values && size) {
		if(numel == 1) _printf_(flag,"        values: %s\n" ,(values[0] ? "true" : "false"));
		else{
			StringFromSize(cstr,size,ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"logical");
		}
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionLogical::DeepEcho() {{{1*/
void  OptionLogical::DeepEcho(){

	char  indent[81]="";

	OptionLogical::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionLogical::DeepEcho(char* indent) {{{1*/
void  OptionLogical::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionLogical DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));
	strcat(indent2,"  ");

	if (values) {
		if(numel==1) _printf_(flag,"%s        values: %s\n" ,indent,(values[0] ? "true" : "false"));
		else{
			dims=(int *) xmalloc(ndims*sizeof(int));
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,i,size,ndims);
				StringFromDims(cstr,dims,ndims);
				_printf_(flag,"%s        values%s: %s\n" ,indent,cstr,(values[i] ? "true" : "false"));
			}
			xfree((void**)&dims);
		}
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionLogical::Name {{{1*/
char* OptionLogical::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionLogical::NumEl {{{1*/
int   OptionLogical::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionLogical::NDims {{{1*/
int   OptionLogical::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionLogical::Size {{{1*/
int*  OptionLogical::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionLogical::Get(bool* pvalue) {{{1*/
void OptionLogical::Get(bool* pvalue){

	/*We should first check that the size is one*/
	if(this->NumEl()!=1){
		_error_("option \"%s\" has %i elements and cannot return a single bool",this->name,this->NumEl());
	}

	/*Assign output pointer*/
	*pvalue=this->values[0];
}
/*}}}*/
