/*!\file OptionChar.cpp
 * \brief: implementation of the optionschar object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionChar::OptionChar(){{{1*/
OptionChar::OptionChar(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionChar::~OptionChar(){{{1*/
OptionChar::~OptionChar(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionChar::Echo {{{1*/
void  OptionChar::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionChar Echo:\n");
	Option::Echo();

	if (values && size) {
//		if (numel == 1) {
		if (1) {
//			_printf_(flag,"        values: \"%s\"\n" ,values[0]);
			_printf_(flag,"        values: \"%s\"\n" ,values);
		}
		else {
			StringFromSize(cstr,size,ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"char");
		}
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionChar::DeepEcho() {{{1*/
void  OptionChar::DeepEcho(){

	char  indent[81]="";

	OptionChar::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionChar::DeepEcho(char* indent) {{{1*/
void  OptionChar::DeepEcho(char* indent){

	int   i,nstr,ipt=0;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionChar DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));
	strcat(indent2,"  ");

	if (values) {
		if (ndims == 2 && size[0] == 1) {
			_printf_(flag,"%s        values: \"%s\"\n" ,indent,values);
		}
		else {
			nstr=size[0];
			for (i=2; i<ndims; i++) nstr*=size[i];

			dims=(int *) xmalloc(ndims*sizeof(int));
			for (i=0; i<nstr; i++) {
				RowWiseDimsFromIndex(dims,ipt,size,ndims);
				StringFromDims(cstr,dims,ndims);
				_printf_(flag,"%s        values%s: \"%.*s\"\n" ,indent,cstr,size[1],&(values[ipt]));
				ipt+=size[1];
			}
			xfree((void**)&dims);
		}
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionChar::Name {{{1*/
char* OptionChar::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionChar::NumEl {{{1*/
int   OptionChar::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionChar::NDims {{{1*/
int   OptionChar::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionChar::Size {{{1*/
int*  OptionChar::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionChar::Get(char** pvalue) {{{1*/
void OptionChar::Get(char** pvalue){

	char* outstring=NULL;
	int   stringsize;

	stringsize=strlen(this->values)+1;

	outstring=(char*)xmalloc(stringsize*sizeof(char));
	memcpy(outstring,this->values,stringsize*sizeof(char));

	*pvalue=outstring;
}
/*}}}*/
/*FUNCTION OptionChar::Get(char*** ppvalue,int *pnumel) {{{1*/
void OptionChar::Get(char*** ppvalue,int *pnumel){

	char* outstring=NULL;
	int   stringsize;
	int   i,nstr,ipt=0;

	/*We should first check that the size is at least one*/
	if(this->NumEl()<=0){
		_error_("option \"%s\" is empty and cannot return a string vector",this->name);
	}

	/*Calculate the size and number of strings*/
	stringsize=this->size[1]+1;
	nstr=this->size[0];
	for (i=2; i<this->ndims; i++) nstr*=this->size[i];

	/*Break concatenated string into individual strings*/
	*ppvalue=(char **) xmalloc(nstr*sizeof(char *));
	for (i=0; i<nstr; i++) {
		outstring=(char*)xmalloc(stringsize*sizeof(char));
		memcpy(outstring,&(this->values[ipt]),(stringsize-1)*sizeof(char));
		outstring[stringsize-1]='\0';
		(*ppvalue)[i]=outstring;
		ipt+=stringsize-1;
	}

	/*Assign output pointer*/
	if(numel) *pnumel=nstr;
}
/*}}}*/
