/*!\file KML_LinearRing.cpp
 * \brief: implementation of the kml_linearring object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
#include "../../modules/Ll2xyx/Ll2xyx.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_LinearRing::KML_LinearRing(){{{1*/
KML_LinearRing::KML_LinearRing(){

	extrude   =false;
	tessellate=false;
	memcpy(altmode,"clampToGround",(strlen("clampToGround")+1)*sizeof(char));

	ncoord    =0;
	coords    =NULL;

}
/*}}}*/
/*FUNCTION KML_LinearRing::~KML_LinearRing(){{{1*/
KML_LinearRing::~KML_LinearRing(){

	if (coords) xfree((void**)&coords);

	coords    =NULL;
	ncoord    =0;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_LinearRing::Echo {{{1*/
void  KML_LinearRing::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_LinearRing:\n");
	KML_Geometry::Echo();

	_printf_(flag,"       extrude: %s\n"          ,(extrude ? "true" : "false"));
	_printf_(flag,"    tessellate: %s\n"          ,(tessellate ? "true" : "false"));
	_printf_(flag,"       altmode: \"%s\"\n"      ,altmode);
	_printf_(flag,"        coords: (ncoord=%d)\n" ,ncoord);

	return;
}
/*}}}*/

/*FUNCTION KML_LinearRing::DeepEcho {{{1*/
void  KML_LinearRing::DeepEcho(){

	char  indent[81]="";

	KML_LinearRing::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LinearRing::DeepEcho {{{1*/
void  KML_LinearRing::DeepEcho(char* indent){

	int   i;
	bool  flag=true;

	_printf_(flag,"%sKML_LinearRing:\n",indent);
	KML_Geometry::DeepEcho(indent);

	_printf_(flag,"%s       extrude: %s\n"          ,indent,(extrude ? "true" : "false"));
	_printf_(flag,"%s    tessellate: %s\n"          ,indent,(tessellate ? "true" : "false"));
	_printf_(flag,"%s       altmode: \"%s\"\n"      ,indent,altmode);
	_printf_(flag,"%s        coords: (ncoord=%d)\n" ,indent,ncoord);
	for (i=0; i<ncoord; i++)
		_printf_(flag,"%s                (%g,%g,%g)\n" ,indent,
				coords[i][0],coords[i][1],coords[i][2]);

	return;
}
/*}}}*/

/*FUNCTION KML_LinearRing::Write {{{1*/
void  KML_LinearRing::Write(FILE* filout,char* indent){

	int   i;

	fprintf(filout,"%s<LinearRing",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_Geometry::Write(filout,indent);

	fprintf(filout,"%s  <extrude>%d</extrude>\n",indent,(extrude ? 1 : 0));
	fprintf(filout,"%s  <tessellate>%d</tessellate>\n",indent,(tessellate ? 1 : 0));
	fprintf(filout,"%s  <altitudeMode>%s</altitudeMode>\n",indent,altmode);
	fprintf(filout,"%s  <coordinates>\n",indent);

/*  loop over the coordinates for the linearring  */

	for (i=0; i<ncoord; i++)
		fprintf(filout,"%s    %0.16g,%0.16g,%0.16g\n",indent,
				coords[i][0],coords[i][1],coords[i][2]);

	fprintf(filout,"%s  </coordinates>\n",indent);
	fprintf(filout,"%s</LinearRing>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LinearRing::Read {{{1*/
void  KML_LinearRing::Read(FILE* fid,char* kstr){

	char*        kstri;

/*  get object attributes  */

	KMLFileTagAttrib(this,
					 kstr);

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</LinearRing",12)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_LinearRing::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_LinearRing::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<extrude>"))
			KMLFileTokenParse(&extrude   ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<tessellate>"))
			KMLFileTokenParse(&tessellate,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<altitudeMode>"))
			KMLFileTokenParse( altmode   ,NULL,KML_LINEARRING_ALTMODE_LENGTH,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<coordinates>"))
			KMLFileTokenParse(&coords    ,&ncoord    ,0,
							  kstri,
							  fid);

		else if (!strncmp(kstri,"<",1))
			KML_Geometry::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

/*FUNCTION KML_LinearRing::WriteExp {{{1*/
void  KML_LinearRing::WriteExp(FILE* fid,char* nstr,int sgn,double cm,double sp){

	int     i;
	double  *lat,*lon,*x,*y;
	char    nstr2[81];

/*  extract latitude and longitude into vectors  */

	lat=(double *) xmalloc(ncoord*sizeof(double));
	lon=(double *) xmalloc(ncoord*sizeof(double));
	for (i=0; i<ncoord; i++) {
		lon[i]=coords[i][0];
		lat[i]=coords[i][1];
	}

/*  convert latitude and longitude to x and y  */

	x  =(double *) xmalloc(ncoord*sizeof(double));
	y  =(double *) xmalloc(ncoord*sizeof(double));
	Ll2xyx(x,y,lat,lon,ncoord,sgn,cm,sp);

/*  write header  */

	memcpy(nstr2,nstr,(strlen(nstr)+1)*sizeof(char));

	for (i=0; i<strlen(nstr2); i++)
		if ((nstr2[i] == ' ') || (nstr2[i] == '\t'))
			nstr2[i]='_';
	fprintf(fid,"## Name:%s\n",nstr2);
	fprintf(fid,"## Icon:0\n");
	fprintf(fid,"# Points Count	Value\n");
	if ((lat[ncoord-1] != lat[0]) || (lon[ncoord-1] != lon[0]))
	    fprintf(fid,"%u	%s\n",ncoord+1,"1.");
	else
	    fprintf(fid,"%u	%s\n",ncoord  ,"1.");
	fprintf(fid,"# X pos	Y pos\n");

/*  write vertices, making sure ring is closed  */

	for (i=0; i<ncoord; i++)
	    fprintf(fid,"%lf\t%lf\n",x[i],y[i]);
	if ((lat[ncoord-1] != lat[0]) || (lon[ncoord-1] != lon[0]))
	    fprintf(fid,"%lf\t%lf\n",x[0],y[0]);

/*  write blank line  */

	fprintf(fid,"\n");

	xfree((void**)&y);
	xfree((void**)&x);
	xfree((void**)&lon);
	xfree((void**)&lat);

	return;
}
/*}}}*/

