/*!\file IntVecParam.c
 * \brief: implementation of the IntVecParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*IntVecParam constructors and destructor*/
/*FUNCTION IntVecParam::IntVecParam(){{{1*/
IntVecParam::IntVecParam(){
	return;
}
/*}}}*/
/*FUNCTION IntVecParam::IntVecParam(int enum_type,int* values,int M){{{1*/
IntVecParam::IntVecParam(int in_enum_type,int* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	if(M){
		values=(int*)xmalloc(M*sizeof(int));
		memcpy(values,in_values,M*sizeof(int));
	}
	else values=NULL;
}
/*}}}*/
/*FUNCTION IntVecParam::IntVecParam(int enum_type,double* values,int M){{{1*/
IntVecParam::IntVecParam(int in_enum_type,double* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	if(M){
		values=(int*)xmalloc(M*sizeof(int));
		for(int i=0;i<in_M;i++) values[i]=(int)in_values[i];
	}
	else values=NULL;
}
/*}}}*/
/*FUNCTION IntVecParam::~IntVecParam(){{{1*/
IntVecParam::~IntVecParam(){
	xfree((void**)&values);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntVecParam::Echo {{{1*/
void IntVecParam::Echo(void){

	printf("IntVecParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   vector size: %i\n",this->M);

}
/*}}}*/
/*FUNCTION IntVecParam::DeepEcho{{{1*/
void IntVecParam::DeepEcho(void){

	int i;
	
	printf("IntVecParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   vector size: %i\n",this->M);
	for(i=0;i<this->M;i++){
		printf("%i %g\n",i,this->values[i]);
	}
}
/*}}}*/
/*FUNCTION IntVecParam::Id{{{1*/
int    IntVecParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntVecParam::MyRank{{{1*/
int    IntVecParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION IntVecParam::Marshall{{{1*/
void  IntVecParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of IntVecParam: */
	enum_value=IntVecParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall IntVecParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	if(M)memcpy(marshalled_dataset,values,M*sizeof(int));marshalled_dataset+=M*sizeof(int);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION IntVecParam::MarshallSize{{{1*/
int   IntVecParam::MarshallSize(){
	
	return sizeof(M)+
		+M*sizeof(int)
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION IntVecParam::Demarshall{{{1*/
void  IntVecParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	if(M) {
		values=(int*)xmalloc(M*sizeof(int));
		memcpy(values,marshalled_dataset,M*sizeof(int));marshalled_dataset+=M*sizeof(int);
	}

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION IntVecParam::Enum{{{1*/
int IntVecParam::Enum(void){

	return IntVecParamEnum;

}
/*}}}*/
/*FUNCTION IntVecParam::copy{{{1*/
Object* IntVecParam::copy() {
	
	return new IntVecParam(this->enum_type,this->values,this->M);

}
/*}}}*/

/*IntVecParam virtual functions definitions: */
/*FUNCTION IntVecParam::GetParameterValue{{{1*/
void  IntVecParam::GetParameterValue(int** pintarray,int* pM){
	int* output=NULL;

	if(M){
		output=(int*)xmalloc(M*sizeof(int));
		memcpy(output,values,M*sizeof(int));
	}

	/*Assign output pointers:*/
	if(pM) *pM=M;
	*pintarray=output;
}
/*}}}*/
/*FUNCTION IntVecParam::GetParameterName{{{1*/
char* IntVecParam::GetParameterName(void){
	return  EnumToStringx(this->enum_type);
}
/*}}}*/
/*FUNCTION IntVecParam::SetMatlabField{{{1*/
#ifdef _SERIAL_
void  IntVecParam::SetMatlabField(mxArray* dataref){

	char    *name      = NULL;
	double  *doublevec = NULL;
	int     *intvec    = NULL;
	mxArray *pfield    = NULL;

	this->GetParameterValue(&intvec,NULL);
	name=this->GetParameterName();

	/*cast intvec into doublevec for Matlab*/
	if(M){
		doublevec=(double*)xmalloc(M*sizeof(double));
		for(int i=0;i<M;i++)doublevec[i]=(double)intvec[i];
	}
	else doublevec=NULL;
	xfree((void**)&intvec);
				
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,M);
	mxSetN(pfield,1);
	mxSetPr(pfield,doublevec);
	
	mxSetField(dataref, 0, name, pfield);
}
#endif
/*}}}*/
/*FUNCTION IntVecParam::SetValue{{{1*/
void  IntVecParam::SetValue(int* intarray,int in_M){

	/*avoid leak: */
	xfree((void**)&this->values);

	if(in_M){
		this->values=(int*)xmalloc(in_M*sizeof(int));
		memcpy(this->values,intarray,in_M*sizeof(int));
	}
	else this->values=NULL;

	this->M=in_M;
}
/*}}}*/
