/*!\file OptionCell.cpp
 * \brief: implementation of the optionscell object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionCell::OptionCell(){{{1*/
OptionCell::OptionCell(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionCell::~OptionCell(){{{1*/
OptionCell::~OptionCell(){

	if (values){
		delete values;
		values    =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionCell::Echo {{{1*/
void  OptionCell::Echo(){

	char cstr[81];
	bool flag     = true;

	_printf_(flag,"OptionCell Echo:\n");
	Option::Echo();

	if (values && size) {
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"        values: %s %s\n" ,cstr,"cell");
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionCell::DeepEcho() {{{1*/
void  OptionCell::DeepEcho(){

	char  indent[81]="";

	OptionCell::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionCell::DeepEcho(char* indent) {{{1*/
void  OptionCell::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionCell DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values->Size()) {
		dims=(int *) xmalloc(ndims*sizeof(int));
		for (i=0; i<values->Size(); i++) {
			ColumnWiseDimsFromIndex(dims,i,size,ndims);
			StringFromDims(cstr,dims,ndims);
			_printf_(flag,"%s        values: -------- begin %s --------\n" ,indent,cstr);
			((Option *)values->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s        values: --------  end  %s --------\n" ,indent,cstr);
		}
		xfree((void**)&dims);
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionCell::Name {{{1*/
char* OptionCell::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionCell::NumEl {{{1*/
int   OptionCell::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionCell::NDims {{{1*/
int   OptionCell::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionCell::Size {{{1*/
int*  OptionCell::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionCell::Get(Options** pvalue) {{{1*/
void OptionCell::Get(Options** pvalue){

	/*Assign output pointer*/
	*pvalue=this->values;
}
/*}}}*/
