/*!\file Option.cpp
 * \brief: implementation of the optionsobject abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION Option::Option(){{{1*/
Option::Option(){

	name  =NULL;
	numel =0;
	ndims =0;
	size  =NULL;

}
/*}}}*/
/*FUNCTION Option::~Option(){{{1*/
Option::~Option(){

	if(size) xfree((void**)&size);
	if(name) xfree((void**)&name);

}
/*}}}*/

/*Other*/
/*FUNCTION Option::Echo {{{1*/
void  Option::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"          name: \"%s\"\n" ,name);
	_printf_(flag,"         numel: %d\n"     ,numel);
	_printf_(flag,"         ndims: %d\n"     ,ndims);
	if(size){
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"          size: %s\n" ,cstr);
	}
	else _printf_(flag,"          size: [empty]\n" );
}
/*}}}*/
/*FUNCTION Option::DeepEcho() {{{1*/
void  Option::DeepEcho(){

	char  indent[81]="";

	Option::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION Option::DeepEcho(char* indent) {{{1*/
void  Option::DeepEcho(char* indent){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%s          name: \"%s\"\n" ,indent,name);
	_printf_(flag,"%s         numel: %d\n"     ,indent,numel);
	_printf_(flag,"%s         ndims: %d\n"     ,indent,ndims);
	if(size){
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"%s          size: %s\n" ,indent,cstr);
	}
	else _printf_(flag,"%s          size: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION Option::Name {{{1*/
char* Option::Name(){

	return(name);
}
/*}}}*/
/*FUNCTION Option::NumEl {{{1*/
int   Option::NumEl(){

	return(numel);
}
/*}}}*/
/*FUNCTION Option::NDims {{{1*/
int   Option::NDims(){

	return(ndims);
}
/*}}}*/
/*FUNCTION Option::Size {{{1*/
int*  Option::Size(){

	return(size);
}
/*}}}*/
/*FUNCTION Option::Get {{{1*/
//void* Option::Get(){

//	;

//	return;
//}
/*}}}*/
