/*!\file KML_Object.cpp
 * \brief: implementation of the kml_object abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Object::KML_Object(){{{1*/
KML_Object::KML_Object(){

	attrib    =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Object::~KML_Object(){{{1*/
KML_Object::~KML_Object(){

	if (attrib) {
		delete attrib;
		attrib    =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Object::Echo {{{1*/
void  KML_Object::Echo(){

	bool  flag=true;

	_printf_(flag,"        attrib: (size=%d)\n" ,attrib->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Object::DeepEcho {{{1*/
void  KML_Object::DeepEcho(){

	char  indent[81]="";

	KML_Object::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Object::DeepEcho {{{1*/
void  KML_Object::DeepEcho(char* indent){

	int   i;
	bool  flag=true;

/*  loop over the attributes for the object  */

	if (attrib->Size())
		for (i=0; i<attrib->Size(); i++) {
			((KML_Attribute *)attrib->GetObjectByOffset(i))->DeepEcho(indent);
		}
	else
		_printf_(flag,"%s        attrib: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Object::Write {{{1*/
void  KML_Object::Write(FILE* filout,char* indent){

//  attributes always written in keyword line of derived classes

	;

	return;
}
/*}}}*/

/*FUNCTION KML_Object::Read {{{1*/
void  KML_Object::Read(FILE* fid,char* kstr){

/*  process field within opening and closing tags  */

	if      (!strncmp(kstr,"</Object", 8))
		return;
	else if (!strncmp(kstr,"</",2))
		_error_("KML_Object::Read -- Unexpected closing tag %s.\n",kstr);
	else if (strncmp(kstr,"<",1))
		_error_("KML_Object::Read -- Unexpected field \"%s\".\n",kstr);

	else if (!strncmp(kstr,"<",1)) {
		_printf_(true,"KML_Object::Read -- Unrecognized opening tag %s.\n",kstr);
		KMLFileTagSkip(kstr,
					   fid);
	}

	return;
}
/*}}}*/

/*FUNCTION KML_Object::WriteExp {{{1*/
void  KML_Object::WriteExp(FILE* fid,char* nstr,int sgn,double cm,double sp){

	;

	return;
}
/*}}}*/

/*FUNCTION KML_Object::AddAttrib {{{1*/
void  KML_Object::AddAttrib(char* name,char* value){

	KML_Attribute* katt=NULL;

	katt=new KML_Attribute();
	katt->Alloc(name,value);
	katt->Add(attrib);

	return;
}
/*}}}*/

/*FUNCTION KML_Object::FindAttrib {{{1*/
void  KML_Object::FindAttrib(char** pvalue,char* name,char* deflt){

	int   i;
	KML_Attribute* katt=NULL;

/*  loop over any attributes for the object  */

	if (attrib->Size())
		for (i=0; i<attrib->Size(); i++)
			if (!strcmp(((KML_Attribute *)attrib->GetObjectByOffset(i))->name,name)) {
				katt=(KML_Attribute *)attrib->GetObjectByOffset(i);
				break;
			}

/*  if found, get the value; otherwise use the default  */

	if (katt)
		katt->Get(pvalue,deflt);
	else {
		*pvalue=(char *) xmalloc((strlen(deflt)+1)*sizeof(char));
		strcpy(*pvalue,deflt);
	}

	return;
}
/*}}}*/

/*FUNCTION KML_Object::WriteAttrib {{{1*/
void  KML_Object::WriteAttrib(FILE* filout,char* indent){

	int   i;

//  attributes always written in keyword line of kml_object

/*  loop over any attributes for the object  */

	if (attrib->Size())
		for (i=0; i<attrib->Size(); i++)
			((KML_Attribute *)attrib->GetObjectByOffset(i))->Write(filout,indent);

	return;
}
/*}}}*/

