/*!\file KML_Document.cpp
 * \brief: implementation of the kml_document object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Document::KML_Document(){{{1*/
KML_Document::KML_Document(){

	;

}
/*}}}*/
/*FUNCTION KML_Document::~KML_Document(){{{1*/
KML_Document::~KML_Document(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Document::Echo {{{1*/
void  KML_Document::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Document:\n");
	KML_Container::Echo();

	return;
}
/*}}}*/

/*FUNCTION KML_Document::DeepEcho {{{1*/
void  KML_Document::DeepEcho(){

	char  indent[81]="";

	KML_Document::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Document::DeepEcho {{{1*/
void  KML_Document::DeepEcho(char* indent){

	bool  flag=true;

	_printf_(flag,"%sKML_Document:\n",indent);
	KML_Container::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Document::Write {{{1*/
void  KML_Document::Write(FILE* filout,char* indent){

	fprintf(filout,"%s<Document",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_Container::Write(filout,indent);

	fprintf(filout,"%s</Document>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Document::Read {{{1*/
void  KML_Document::Read(FILE* fid,char* kstr){

	char*        kstri;

/*  get object attributes  */

	KMLFileTagAttrib(this,
					 kstr);

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</Document",10)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Document::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_Document::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strncmp(kstri,"<",1))
			KML_Container::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

