/*! \file IntExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTEXTERNALRESULT_H_
#define _INTEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif

#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class IntExternalResult: public ExternalResult{

	public:
		int    id;
		int    enum_type;
		int    value;
		int    step;
		double time;


		/*IntExternalResult constructors, destructors: {{{1*/
		IntExternalResult();
		IntExternalResult(int id,int enum_type,int value,int step,double time);
		~IntExternalResult();

		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*ExternalResult managemnet: {{{1*/
		int   EnumType(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		char* GetResultName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _INTEXTERNALRESULT_H */
