/*!\file ModelProcessorx
 * \brief: create datasets using input binary file and a set of requested analyses
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../include/include.h"
#include "../../modules/modules.h"

void ModelProcessorx(Elements** pelements, Nodes** pnodes, Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads, Parameters** pparameters, FILE* IOMODEL,const int solution_type,const int nummodels,const int* analysis_type_list){

	int i;
	int analysis_type;
	
	/*output: */
	Elements    *elements    = NULL;
	Nodes       *nodes       = NULL;
	Vertices    *vertices    = NULL;
	Materials   *materials   = NULL;
	Constraints *constraints = NULL;
	Loads       *loads       = NULL;
	Parameters  *parameters  = NULL;

	/*Initialize IoModel from input file*/
	IoModel* iomodel = new IoModel(IOMODEL);
	SetVerbosityLevel(iomodel->verbose);

	for(i=0;i<nummodels;i++){

		analysis_type=analysis_type_list[i];

		/*Hack for trasient runs (to be improved)*/
		if(solution_type==TransientSolutionEnum && analysis_type==ThermalAnalysisEnum && iomodel->dim==2) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==MeltingAnalysisEnum && iomodel->dim==2) continue;
	
		_printf_(VerboseMProcessor(),"   create datasets for analysis %s\n",EnumToStringx(analysis_type));
		CreateDataSets(&elements,&nodes,&vertices,&materials,&constraints,&loads,&parameters,iomodel,IOMODEL,solution_type,analysis_type,nummodels,i);
	}

	/*Free ressources:*/
	delete iomodel;

	/*Assign output pointers:*/
	*pelements=elements;
	*pnodes=nodes;
	*pvertices=vertices;
	*pmaterials=materials;
	*pconstraints=constraints;
	*ploads=loads;
	*pparameters=parameters;

}
