#!/bin/bash

#wget http://ftp.stack.nl/pub/users/dimitri/doxygen-1.7.4.src.tar.gz

#Get number of cpus on current platform
NUMCPUS=$1;

#version of doxygen
version=`echo *.src.tar.gz | sed 's/\.src\.tar\.gz//g' | sed 's/doxygen-//g'`

#Some cleanup
rm -rf src
rm -rf install
rm -rf doxygen-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  doxygen-$version.src.tar.gz

#Move doxygen into src directory
mv doxygen-$version/* src
rm -rf doxygen-$version

#Configure doxygen
cd src && ./configure --prefix "$ISSM_TIER/externalpackages/doxygen/install"

#Compile doxygen
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi

#Install doxygen
make  install
make install_docs
