#!/bin/bash

#remove previous doc
rm -rf "$ISSM_TIER/doxygen/doc_m/matlabhtml"

#copy issm_template in m2html
cd $ISSM_TIER/externalpackages/m2html/install/templates
ln -s $ISSM_TIER/doxygen/doc_m/template_issm ./template_issm

#go to the main directory
cd $ISSM_TIER

#launch matlab
matlab -nodisplay << EOF

	%Add m2html in path
	addpath(genpath_ice([issmtier() '/externalpackages/m2html/install']));

	%Here are the subdirectories we want to go through:
	mfiles={'src/m'};

	%run m2html, and dump the documentation in ISSM_TIER/doc/website/doc_m/matlabhtml
	m2html('htmldir',[issmtier() '/doxygen/doc_m/matlabhtml'],'recursive','on','source','on',...
	'syntaxHighlighting','on','globalHypertextLinks','on','global','on','template','template_issm',...
	'graph','off','index','menu','mFiles',mfiles);
EOF

#remove soft link
rm "$ISSM_TIER/externalpackages/m2html/install/templates/template_issm"
