#!/bin/bash

#remove previous doc
rm -rf "$ISSM_TIER/doc/website/doc_m/matlabhtml"

#copy issm_template in m2html
cd "$ISSM_TIER/externalpackages/m2html/install/templates"
ln -s "$ISSM_TIER/../website/doc_m/template_issm" ./template_issm

#go to the main directory
cd $ISSM_TIER

#launch matlab
matlab -nodisplay << EOF
	%get ISSM_TIER, brief name
	[status,ISSM_TIER_BRIEF]=system('basename `pwd`');
	ISSM_TIER_BRIEF=ISSM_TIER_BRIEF(1:end-1); %skip the \n character
	if status~=0 | isempty(ISSM_TIER_BRIEF) | length(ISSM_TIER_BRIEF)==1,
		error('startup error message: could not retrieve ISSM_TIER brief name');
	end

	%Add m2html in path
	addpath(genpath_ice([ISSM_TIER '/externalpackages/m2html/install']));

	cd ../

	%Here are the subdirectories we want to go through:
	mfiles={[ISSM_TIER_BRIEF '/src/m']};
	%mfiles={[ISSM_TIER_BRIEF '/src/m/classes/public/plot']};

	%run m2html, and dump the documentation in ISSM_TIER/doc/website/doc_m/matlabhtml
	m2html('htmldir',[ISSM_TIER '/../website/doc_m/matlabhtml'],'recursive','on','source','on',...
	'syntaxHighlighting','on','globalHypertextLinks','on','global','on','template','template_issm',...
	'graph','on','index','menu','mFiles',mfiles);
EOF

#remove soft link
rm "$ISSM_TIER/externalpackages/m2html/install/templates/template_issm"
