/*\file UpdateDynamicConstraints.c
 *\brief: update single point constraints inside nodes out of constrain vector ys
 */

#include "./UpdateDynamicConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes* nodes=NULL;
	Parameters* parameters=NULL;
	Vec ys=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateDynamicConstraintsUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&nodes,NODESIN);
	FetchMatlabData((Parameters**)&parameters,PARAMETERS);
	FetchMatlabData(&ys,YS);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateDynamicConstraintsx(nodes,parameters,ys);

	/*write output datasets: */
	WriteMatlabData(NODESOUT,nodes);

	/*Free ressources: */
	delete nodes;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void UpdateDynamicConstraintsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: m.nodes=%s(m.nodes,m.parameters,ys);\n",__FUNCT__);
	_printf_(true,"\n");
}
