/*!\file: ResetBoundaryConditions.cpp
 * \brief: change boundary conditions of a model, using a solution vector from another analysis
 */ 

#include "../objects/objects.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ResetBoundaryConditions(FemModel* femmodel, int analysis_type){
	
	/*variables: */
	Vec yg=NULL;
	Vec ys=NULL;
	Nodes* nodes=NULL;
	int i;

	_printf_(VerboseSolution(),"%s\n","   updating boundary conditions...");
			
	/*set current analysis: */
	femmodel->SetCurrentConfiguration(analysis_type);

	/*recover nodes: */
	nodes=femmodel->nodes;

	/*retrieve boundary conditions from element inputs :*/
	GetSolutionFromInputsx( &yg, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,  femmodel->parameters);
	Reducevectorgtosx(&ys,yg,femmodel->nodes,femmodel->parameters);

	/*update spcs using this new vector of constraints: */
	UpdateDynamicConstraintsx(femmodel->nodes,femmodel->parameters,ys);

	/*Free ressources:*/
	VecFree(&ys);
	VecFree(&yg);
}
