function femmodel=ResetBoundaryConditions(femmodel,analysis_type);
%RESETBOUNDARYCONDITIONS - change boundary conditions of a model
%
%   Change boundary condition of a model using a vector solution from another model
%
%   Usage:
%      femmodel=ResetBoundaryConditions(femmodel,analysis_type)

	issmprintf(VerboseSolution,'\n%s',['   updating boundary condition ...']);

	%set current analysis: 
	femmodel=SetCurrentConfiguration(femmodel,analysis_type);

	%recreate constraints vector for the current analysis
	ug=GetSolutionFromInputs(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
	ys=Reducevectorgtos(ug,femmodel.nodes,femmodel.parameters);

	%update values of spcs inside nodes
	femmodel.nodes=UpdateDynamicConstraints(femmodel.nodes,femmodel.parameters,ys);
