/*!\file UpdateDynamicConstraintsx
 * \brief module to update single point constraints  out of new spc vector, for next time step.
 */

#include "./UpdateDynamicConstraintsx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void UpdateDynamicConstraintsx(Nodes* nodes,Parameters* parameters,Vec ys){
	
	int i;
	int configuration_type;
	double* ys_serial=NULL;

	/*retrieve parameters: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);

	if(nodes->NumberOfNodes(configuration_type)){ 

		/*serialize ys, so nodes can index into it: */
		VecToMPISerial(&ys_serial,ys);

		/*Go through all nodes, and ask them to retrieve values from ys and then update their spc values :*/
		for(i=0;i<nodes->Size();i++){

			Node* node=(Node*)nodes->GetObjectByOffset(i);

			/*Check that this node corresponds to our analysis currently being carried out: */
			if (node->InAnalysis(configuration_type)){

				/*For this object, reset values of spc fields in the node: */
				node->UpdateSpcs(ys_serial);
			}
		}
	}

	/*Free ressources:*/
	xfree((void**)&ys_serial);
}
