/*!\file SpcTransient.h
 * \brief: header file for spc object
 */

#ifndef _SPCTRANSIENT_H_
#define _SPCTRANSIENT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class SpcTransient: public Constraint{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double* values; /*different values in time*/
		double* times; /*different time steps*/
		int nsteps; /*number of time steps*/
		int analysis_type;

	public:

		/*SpcTransient constructors, destructors:{{{1*/
		SpcTransient();
		SpcTransient(int sid,int nodeid, int dof,int nsteps, double* times, double* values,int analysis_type);
		~SpcTransient();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Constraint virtual functions definitions: {{{1*/
		void   ConstrainNode(Nodes* nodes,Parameters* parameters);
		bool   InAnalysis(int analysis_type);
		/*}}}*/
		/*SpcTransient management:{{{1 */
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		/*}}}*/

};

#endif  /* _SPCTRANSIENT_H_ */
