/*!\file SpcStatic.h
 * \brief: header file for spc object
 */

#ifndef _SPCStatic_H_
#define _SPCStatic_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class SpcStatic: public Constraint{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double value; /*value*/
		int analysis_type;

	public:

		/*SpcStatic constructors, destructors:{{{1*/
		SpcStatic();
		SpcStatic(int sid,int nodeid, int dof,double value,int analysis_type);
		~SpcStatic();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Constraint virtual functions definitions: {{{1*/
		void   ConstrainNode(Nodes* nodes,Parameters* parameters);
		bool   InAnalysis(int analysis_type);
		/*}}}*/
		/*SpcStatic management:{{{1 */
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		/*}}}*/

};

#endif  /* _SPCStatic_H_*/
