function displayflaim(md)
%DISPLAYFLAIM - display flaim computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   flaim computation from model md, only if requested.
%
%   Usage:
%      displayflaim(md)

disp(sprintf('   FLAIM - Flight Line Adaptation using Ice sheet Modeling:')); 

disp(sprintf('\n      Input:'));
fielddisplay(md,'fm_tracks'             ,'name of kml tracks file');
fielddisplay(md,'fm_flightreqs'         ,'structure of kml flight requirements');
fielddisplay(md,'fm_criterion'          ,'element or nodal criterion for flight path evaluation');

disp(sprintf('\n      Arguments:'));
fielddisplay(md,'fm_gridsatequator'     ,'number of grids at equator (determines resolution)');
fielddisplay(md,'fm_usevalueordering'   ,'flag to consider target values for flight path evaluation');
fielddisplay(md,'fm_split_antimeridian' ,'flag to split polygons on the antimeridian');

disp(sprintf('\n      Output:'));
fielddisplay(md,'fm_solution'           ,'name of kml solution file');
fielddisplay(md,'fm_quality'            ,'quality of kml solution');

end
