/*!\file KML_Placemark.cpp
 * \brief: implementation of the kml_placemark object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Placemark::KML_Placemark(){{{1*/
KML_Placemark::KML_Placemark(){

	geometry  =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Placemark::~KML_Placemark(){{{1*/
KML_Placemark::~KML_Placemark(){

	if (geometry) {
		delete geometry;
		geometry  =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Placemark::Echo {{{1*/
void  KML_Placemark::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Placemark:\n");
	KML_Feature::Echo();

	_printf_(flag,"      geometry: (size=%d)\n" ,geometry->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::DeepEcho {{{1*/
void  KML_Placemark::DeepEcho(){

	char  indent[81]="";

	KML_Placemark::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::DeepEcho {{{1*/
void  KML_Placemark::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Placemark:\n",indent);
	KML_Feature::DeepEcho(indent);

/*  loop over the geometry elements for the placemark  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (geometry->Size())
		for (i=0; i<geometry->Size(); i++) {
			_printf_(flag,"%s      geometry: -------- begin [%d] --------\n" ,indent,i);
			((KML_Geometry *)geometry->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s      geometry: --------  end  [%d] --------\n" ,indent,i);
		}
	else
		_printf_(flag,"%s      geometry: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::Write {{{1*/
void  KML_Placemark::Write(FILE* filout,char* indent){

	int   i;
	char  indent2[81];

	fprintf(filout,"%s<Placemark",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");

	KML_Feature::Write(filout,indent);

/*  loop over the geometry elements for the placemark  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	for (i=0; i<geometry->Size(); i++)
		((KML_Geometry *)geometry->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</Placemark>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::Read {{{1*/
void  KML_Placemark::Read(FILE* fid,char* kstr){

	char*        kstri;
	KML_Object*  kobj;

/*  get object attributes  */

	KMLFileTagAttrib(this,
					 kstr);

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</Placemark",11)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Placemark::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_Placemark::Read -- Unexpected field \"%s\".\n",kstri);

//		else if (!strncmp(kstri,"<Point", 6)) {
//			kobj=(KML_Object*)new KML_Point();
//			kobj->Read(fid,kstri);
//			geometry  ->AddObject((Object*)kobj);
//		}

		else if (!strncmp(kstri,"<LineString",11)) {
			kobj=(KML_Object*)new KML_LineString();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LinearRing",11)) {
			kobj=(KML_Object*)new KML_LinearRing();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Polygon", 8)) {
			kobj=(KML_Object*)new KML_Polygon();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<MultiGeometry",14)) {
			kobj=(KML_Object*)new KML_MultiGeometry();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<",1))
			KML_Feature::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::WriteExp {{{1*/
void  KML_Placemark::WriteExp(FILE* fid,char* nstr,int sgn,double cm,double sp){

	int   i;
	char  nstr2[81];

/*  loop over the geometry elements for the placemark  */

	for (i=0; i<geometry->Size(); i++) {
		if (strlen(nstr))
			sprintf(nstr2,"%s %s",nstr,name);
		else
			sprintf(nstr2,"%s",name);

		((KML_Object *)geometry->GetObjectByOffset(i))->WriteExp(fid,nstr2,sgn,cm,sp);
	}

	return;
}
/*}}}*/

