/*
 * UpdateElementsPrognostic:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsPrognostic(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAccumulationRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAblationRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceMassBalanceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BasalMeltingRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BasalMeltingRateCorrectionEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VxEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VyEnum);

	if(iomodel->prognostic_DG){
		IoModelToInputsx(elements,iomodel,iomodel_handle,SpcthicknessEnum); //for DG, we need the spc in the element
	}
	
	if (iomodel->dim==3){
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnBedEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnSurfaceEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,PressureEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,TemperatureEnum);
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
}
