function dof=modelsize(models)
%DOF - return the maximum number of degrees of freedom of the model
%
%   Usage:
%      dof=modelsize(m_dh,m_dv,m_ds,m_dhu,m_sl)

%recover models
m_dh=models.dh;
m_dv=models.dv;
m_ds=models.ds;
m_dhu=models.dhu;
m_sl=models.sl;

dof=0;
if ~isempty(m_ds.nodesets),
	dof=m_ds.nodesets.fsize; %biggest dof number
end
if ~isempty(m_dh.nodesets),
	if dof<m_dh.nodesets.fsize,
		dof=m_dh.nodesets.fsize; %biggest dof number
	end
end
if ~isempty(m_dhu.nodesets),
	if dof<m_dhu.nodesets.fsize,
		dof=m_dhu.nodesets.fsize;
	end
end
