function outoptions=process_solve_options(options)
%DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
%
%   Usage:
%      options=process_solve_options(options)
%
%   See also: SOLVE

%solution_type: check on this option, error out otherwise
solution_type=getfieldvalue(options,'solution_type');
if ischar(solution_type), error(['only Enums are supported as ''solution_type''. For example: md=solve(md,''solution_type'',DiagnosticSolutionEnum); ']); end
if ~ismember(solution_type,[DiagnosticSolutionEnum,PrognosticSolutionEnum,ThermalSolutionEnum,...
		SteadystateSolutionEnum,ParametersSolutionEnum,TransientSolutionEnum,EnthalpySolutionEnum,...
		BalancethicknessSolutionEnum,BedSlopeSolutionEnum,SurfaceSlopeSolutionEnum,GroundingLineMigration2DSolutionEnum,HydrologySolutionEnum,FlaimSolutionEnum]),
	error(['process_solve_options error message: solution_type ' EnumToString(solution_type) ' not supported yet!']);
end
outoptions.solution_type=solution_type;

outoptions.upload=getfieldvalue(options,'upload','off');
outoptions.batch=getfieldvalue(options,'batch','no');
outoptions.directory=getfieldvalue(options,'directory','');

%  process qmu arguments
outoptions.qmudir=getfieldvalue(options,'qmudir',['qmu' num2str(feature('GetPid'))]);  % qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
outoptions.qmufile=getfieldvalue(options,'qmufile','qmu');% qmufile cannot be changed unless ????script.sh is also changed
outoptions.overwrite=getfieldvalue(options,'overwrite','n');
outoptions.keep=getfieldvalue(options,'keep','n');
outoptions.ivar=getfieldvalue(options,'ivar',1);
outoptions.iresp=getfieldvalue(options,'iresp',1);
outoptions.imethod=getfieldvalue(options,'imethod',1);
outoptions.iparams=getfieldvalue(options,'iparams',1);
outoptions.runmpi=getfieldvalue(options,'runmpi',false);

%  process flaim arguments
outoptions.fmdir=getfieldvalue(options,'fmdir',['fm' num2str(feature('GetPid'))]);
outoptions.fmfile=getfieldvalue(options,'fmfile','fm_targets');
outoptions.overwrite=getfieldvalue(options,'overwrite','n');
outoptions.keep=getfieldvalue(options,'keep','y');
outoptions.latsgn=getfieldvalue(options,'latsgn',0);
outoptions.cmap=getfieldvalue(options,'cmap',[]);
