/*! \file KML_MultiGeometry.h 
 *  \brief: header file for kml_multigeometry object
 */

#ifndef _KML_MULTIGEOMETRY_H_
#define _KML_MULTIGEOMETRY_H_

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Geometry.h"
class KML_Geometry;
class DataSet;
/*}}}*/

class KML_MultiGeometry: public KML_Geometry {

	public:

		DataSet* geometry;

		/*KML_MultiGeometry constructors, destructors {{{1*/
		KML_MultiGeometry();
		~KML_MultiGeometry();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		void  Read(FILE* fid,char* kstr);
		void  FindPolygons(DataSet* polygons);
		void  FindLineStrings(DataSet* linestrings);
		int   Id(){_error_("Not implemented yet.");};
		int   MyRank(){_error_("Not implemented yet.");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   MarshallSize(){_error_("Not implemented yet.");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   Enum(){_error_("Not implemented yet.");};
		Object* copy(){_error_("Not implemented yet.");};
		/*}}}*/

};
#endif  /* _KML_MULTIGEOMETRY_H */

