function partvector=AreaAverageOntoPartition(md,vector,layer)
%AREAAVERAGEONTOPARTITION 
%   compute partition values for a certain vector expressed on the vertices of the mesh.
%   Use area weighted average.
%
%   Usage:
%      average=AreaAverageOntoPartition(md,vector)
%      average=AreaAverageOntoPartition(md,vector,layer) %if in 3D, chose which layer is partitioned

%some checks
if md.dim==3,
	if nargin~=3,
		error('layer should be provided onto which Area Averaging occurs');
	end
	%save 3D model
	md3d=md;
	
	md.elements=md.elements2d;
	md.x=md.x2d;
	md.y=md.y2d;
	md.numberofnodes=md.numberofnodes2d;
	md.numberofelements=md.numberofelements2d;
	md.vwgt=[];
	md.nodeconnectivity=[];

	%run connectivity routine
	md=adjacency(md);

	%finally, project vector: 
	vector=project2d(md3d,vector,layer);
	md.part=project2d(md3d,md3d.part,layer);
end

%ok, first check that part is Matlab indexed
part=md.part+1;

%some check: 
if md.npart~=max(part),
	error('AreaAverageOntoPartition error message: ''npart'' should be equal to max(md.part)');
end

%initialize output
partvector=zeros(max(part),1);

%start weight average
weightedvector=vector.*md.vwgt;
for i=1:max(part),
	pos=find(part==i);
	partvector(i)=sum(weightedvector(pos))/sum(md.vwgt(pos));
end

%in 3D, restore 3D model:
if md.dim==3,
	md=md3d;
end
