/*
 * UpdateElementsThermal:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsThermal(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Now, is the model 3d? otherwise, do nothing: */
	if (iomodel->dim==2)return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragCoefficientEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragPEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragQEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragTypeEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnBedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnSurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementsTypeEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyBEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyNEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,PressureEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,TemperatureEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,GeothermalfluxEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VxEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VyEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VzEnum);
	
	if(iomodel->qmu_analysis)elements->InputDuplicate(TemperatureEnum,QmuTemperatureEnum);

	/*Free data: */
	xfree((void**)&iomodel->elements);

	
}
