/*!\file RequestedOutputsx
 * \brief: compute outputs that were requested specifically for this solution, such as BasalStress, StrainHeating, etc ...
 */

#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void RequestedOutputsx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters, int step, double time){


	int  i,o;
	int  numoutputs        = 0;
	int *requested_outputs = NULL;
	int  output_enum;
	Element* element=NULL;

	/*retrieve parameters: */
	parameters->FindParam(&numoutputs,NumRequestedOutputsEnum);
	if(numoutputs) parameters->FindParam(&requested_outputs,&numoutputs,RequestedOutputsEnum);

	if(numoutputs){
		for(o=0;o<numoutputs;o++){
			output_enum=requested_outputs[o];
			/*create this output in the element inputs, and then transfer to results: */
			for(i=0;i<elements->Size();i++){
				element=(Element*)elements->GetObjectByOffset(i);
				element->RequestedOutput(output_enum,step,time);
			}
		}
	}
		
	/*Free ressources:*/
	xfree((void**)&requested_outputs);

}
