/*!\file Matice.h
 * \brief: header file for matice object
 */

#ifndef MATICE_H_
#define MATICE_H_

#include "./Material.h"

class Matice: public Material{

	private: 
		int	   mid;
		double B;
		double n;

	public:

		Matice();
		Matice(int mid,double B,double n);
		~Matice();

		void  Echo();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type);
		void  UpdateFromInputs(ParameterInputs* inputs);
		void  SetB(double B_param);
		void  GetViscosity2d(double* pviscosity, double* pepsilon);
		void  GetViscosity2(double* pviscosity2, double* pepsilon);
		void  GetViscosity3d(double* pviscosity3d, double* pepsilon);
		Object* copy();

};

#endif  /* _MATICE_H_ */
