/*
 * CreateConstraintsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsThermal(Constraints** pconstraints, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	int count;
	
	/*Output*/
	Constraints* constraints = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Only 3d mesh supported*/
	if (iomodel->dim==3){
		IoModelToConstraintsx(constraints,iomodel,iomodel_handle,SpctemperatureEnum,ThermalAnalysisEnum);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
