/*!\file IoModelToConstraintsx
 * \brief: used in ModelProcessor, to retrieve a nodal vector  and to create corresponding constraints using Spc objects
 */

#include "./IoModelToConstraintsx.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void IoModelToConstraintsx(Constraints* constraints,IoModel* iomodel,FILE* iomodel_handle,int vector_enum,int analysis_type){
	

	/*intermediary: */
	int     i,j;
	bool    transient     = false;

	FILE   *fid           = NULL;
	int     code          = 0;
	int     vector_layout = 0;
	int     counter;
	int     nods;
	double* times=NULL;
	double* values=NULL;
	bool    spcpresent=false;
	int     count=0;

	/*variables being fetched: */
	double *doublevector  = NULL;
	int     M,N;


	/*First of, find the record for the enum, and get code  of data type: */
	fid=SetFilePointerToData(&code, &vector_layout,iomodel_handle,vector_enum);

	if(code!=7)_error_("%s%s"," expecting a double vector for constraints with enum ",EnumToStringx(vector_enum));
	if(vector_layout!=1)_error_("%s%s"," expecting a nodal vector for constraints with enum ",EnumToStringx(vector_enum));

	/*Fetch vector:*/
	IoModelFetchData(&doublevector,&M,&N,iomodel_handle,vector_enum);

	/*Transient or static?:*/
	if(M==iomodel->numberofvertices){
		/*static: just create Spc objects*/
		count=0;
	
		/*Create spcs from x,y,z, as well as the spc values on those spcs: */
		for (i=0;i<iomodel->numberofvertices;i++){
			
			/*keep only this partition's nodes:*/
			if((iomodel->my_vertices[i])){

				if (!isnan(doublevector[i])){

					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,doublevector[i],analysis_type));
					count++;
				}
			}
		}
	}
	else if (M==iomodel->numberofvertices+1){
		/*transient: create transient Spct objects. Same logic, except we need to retrieve 
		 * various times and values to initialize an Spct object: */
		count=0;

		/*figure out times: */
		times=(double*)xmalloc(N*sizeof(double));
		for(j=0;j<N;j++){
			times[j]=doublevector[(M-1)*N+j];
		}
		/*unit conversion: */
		UnitConversion(times,N,ExtToIuEnum,TimeEnum);

		/*Create spcs from x,y,z, as well as the spc values on those spcs: */
		for (i=0;i<iomodel->numberofvertices;i++){
			
			/*keep only this partition's nodes:*/
			if((iomodel->my_vertices[i])){

				/*figure out times and values: */
				values=(double*)xmalloc(N*sizeof(double));
				spcpresent=false;
				for(j=0;j<N;j++){
					values[j]=doublevector[i*N+j];
					if(!isnan(values[j]))spcpresent=true; //NaN means no spc by default
				}

				if(spcpresent){
					constraints->AddObject(new Spct(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,N,times,values,analysis_type));
					count++;
				}
				xfree((void**)&values);
			}
		}
	}
	else{
		_error_("Size of field %s not supported",EnumToStringx(vector_enum));
	}

	/*Free ressources:*/
	xfree((void**)&doublevector);
	xfree((void**)&times);
	xfree((void**)&values);
}
