function marshall(md)
%MARSHALL - output JPL-package compatible binary file from @model md, for certain solution type.
%
%   The routine creates a JPL-package compatible binary file from @model md
%   This binary file will be used for parallel runs in JPL-package
%
%   Usage:
%      marshall(md)

disp(['marshalling file ' md.name '.bin']);

%open file for binary writing
fid=fopen([ md.name '.bin'],'wb');
if fid==-1,
	error(['marshall error message: could not open ' [md.name '.bin'],' file for binary writing']);
end

%automatically marshall model md, using template information available from an empty model class.
template=model.template();
fields=fieldnames(template);
for i=1:length(fields),
	field=fields{i};
	marshall=template.(field){2};
	if marshall,
		WriteData(md,fid,template,field);
	end
end

%close file
st=fclose(fid);
if st==-1,
	error(['marshall error message: could not close file ' [md.name '.bin']]);
end
