function displayprognostic(md)
%DISPLAYPROGNOSTIC - display solution parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displayprognostic(md)

disp(sprintf('   Prognostic solution parameters:'));

disp(sprintf('\n      transient:'));
fielddisplay(md,'dt','time step [yr]');
fielddisplay(md,'ndt','time span [yr]');
fielddisplay(md,'artificial_diffusivity','yes->1, no->0');
fielddisplay(md,'prognostic_DG','yes->1, no->0');

disp(sprintf('\n      boundary conditions:'));
fielddisplay(md,'spcthickness','thickness constraints (NaN means no constraint)');
