%
%  display for the nonlinear_equality_constraint class.
%
%  []=display(nec)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(nec)

if ~isa(nec,'nonlinear_equality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(nec),'nonlinear_equality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(nec)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(nec),inputname(1),string_dim(nec,i)));
    disp(sprintf('    descriptor: ''%s'''  ,nec(i).descriptor));
    disp(sprintf('        target: %g'      ,nec(i).target));
    disp(sprintf('    scale_type: ''%s'''  ,nec(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,nec(i).scale));
end

end
