%
%  definition for the continuous_state class.
%
%  [csv]=continuous_state(varargin)
%
%  where the required varargin are:
%    descriptor    (char, description, '')
%    initst        (double, initial state, 0.)
%  and the optional varargin and defaults are:
%    lower         (double, lower bound, -Inf)
%    upper         (double, upper bound,  Inf)
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and two or more
%  arguments constructs a new instance from the arguments.
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
classdef continuous_state
    properties
        descriptor='';
        initst    = 0.;
        lower     =-Inf;
        upper     = Inf;
    end
    
    methods
        function [csv]=continuous_state(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'continuous_state')
                        csv=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'continuous_state');
                    end

%  create the object from the input

                otherwise
                    csv.descriptor=varargin{1};

                    if (nargin >= 2)
                        csv.initst    =varargin{2};
                        if (nargin >= 3)
                            csv.lower     =varargin{3};
                            if (nargin >= 4)
                                csv.upper     =varargin{4};
                                if (nargin > 4)
                                    warning('continuous_state:extra_arg',...
                                        'Extra arguments for object of class ''%s''.',...
                                        class(csv));
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(csv)
            desc=cell(size(csv));
            for i=1:numel(csv)
                desc(i)=cellstr(csv(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [initpt]=prop_initpt(csv)
            initpt=[];
        end
        function [lower] =prop_lower(csv)
            lower=zeros(size(csv));
            for i=1:numel(csv)
                lower(i)=csv(i).lower;
            end
            lower=allequal(lower,-Inf);
        end
        function [upper] =prop_upper(csv)
            upper=zeros(size(csv));
            for i=1:numel(csv)
                upper(i)=csv(i).upper;
            end
            upper=allequal(upper, Inf);
        end
        function [mean]  =prop_mean(csv)
            mean=[];
        end
        function [stddev]=prop_stddev(csv)
            stddev=[];
        end
        function [initst]=prop_initst(csv)
            initst=zeros(size(csv));
            for i=1:numel(csv)
                initst(i)=csv(i).initst;
            end
            initst=allequal(initst,0.);
        end
        function [stype] =prop_stype(csv)
            stype={};
        end
        function [scale] =prop_scale(csv)
            scale=[];
        end
    end
end
