%
%  definition for the objective_function class.
%
%  [of]=objective_function(varargin)
%
%  where the required varargin are:
%    descriptor    (char, description, '')
%  and the optional varargin and defaults are:
%    scale_type    (char, scaling type, 'none')
%    scale         (double, scaling factor, 1.)
%    weight        (double, weighting factor, 1.)
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and one or more
%  arguments constructs a new instance from the arguments.
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
classdef objective_function
    properties
        descriptor='';
        scale_type='none';
        scale     = 1.;
        weight    = 1.;
    end
    
    methods
        function [of]=objective_function(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if  (nargin == 1) && isa(varargin{1},'objective_function')
                        of=varargin{1};
                    else
                        of.descriptor=varargin{1};

                        if (nargin >= 2)
                            of.scale_type=varargin{2};
                            if (nargin >= 3)
                                of.scale     =varargin{3};
                                if (nargin >= 4)
                                    of.weight    =varargin{4};

                                    if (nargin > 4)
                                        warning('objective_function:extra_arg',...
                                            'Extra arguments for object of class ''%s''.',...
                                            class(of));
                                    end
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(of)
            desc=cell(size(of));
            for i=1:numel(of)
                desc(i)=cellstr(of(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [stype] =prop_stype(of)
            stype=cell(size(of));
            for i=1:numel(of)
                stype(i)=cellstr(of(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(of)
            scale=zeros(size(of));
            for i=1:numel(of)
                scale(i)=of(i).scale;
            end
            scale=allequal(scale,1.);
        end
        function [weight]=prop_weight(of)
            weight=zeros(size(of));
            for i=1:numel(of)
                weight(i)=of(i).weight;
            end
            weight=allequal(weight,1.);
        end
        function [lower] =prop_lower(of)
            lower=[];
        end
        function [upper] =prop_upper(of)
            upper=[];
        end
        function [target]=prop_target(of)
            target=[];
        end
    end
end
