%
%  display for the objective_function class.
%
%  []=display(of)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(of)

if ~isa(of,'objective_function')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(of),'objective_function');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(of)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(of),inputname(1),string_dim(of,i)));
    disp(sprintf('    descriptor: ''%s'''  ,of(i).descriptor));
    disp(sprintf('    scale_type: ''%s'''  ,of(i).scale_type));
    disp(sprintf('         scale: %g'      ,of(i).scale));
    disp(sprintf('        weight: %g\n'    ,of(i).weight));
end

end
