%
%  display for the nonlinear_inequality_constraint class.
%
%  []=display(nic)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(nic)

if ~isa(nic,'nonlinear_inequality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(nic),'nonlinear_inequality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(nic)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(nic),inputname(1),string_dim(nic,i)));
    disp(sprintf('    descriptor: ''%s'''  ,nic(i).descriptor));
    disp(sprintf('         lower: %g'      ,nic(i).lower));
    disp(sprintf('         upper: %g'      ,nic(i).upper));
    disp(sprintf('    scale_type: ''%s'''  ,nic(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,nic(i).scale));
end

end
