%
%  display for the linear_equality_constraint class.
%
%  []=display(lec)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(lec)

if ~isa(lec,'linear_equality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(lec),'linear_equality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(lec)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(lec),inputname(1),string_dim(lec,i)));
    disp(sprintf('        matrix: %s'      ,string_vec(lec(i).matrix)));
    disp(sprintf('        target: %g'      ,lec(i).target));
    disp(sprintf('    scale_type: ''%s'''  ,lec(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,lec(i).scale));
end

end

