%
%  display for the continuous_state class.
%
%  []=display(csv)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(csv)

if ~isa(csv,'continuous_state')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(csv),'continuous_state');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(csv)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(csv),inputname(1),string_dim(csv,i)));
    disp(sprintf('    descriptor: ''%s'''  ,csv(i).descriptor));
    disp(sprintf('        initst: %g'      ,csv(i).initst));
    disp(sprintf('         lower: %g'      ,csv(i).lower));
    disp(sprintf('         upper: %g\n'    ,csv(i).upper));
end

end

