%
%  definition for the response_function class.
%
%  [rf]=response_function(varargin)
%
%  where the required varargin are:
%    descriptor    (char, description, '')
%  and the optional varargin and defaults are:
%    respl         (double vector, response levels, [])
%    probl         (double vector, probability levels, [])
%    rell          (double vector, reliability levels, [])
%    grell         (double vector, gen. reliability levels, [])
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and one or more
%  arguments constructs a new instance from the arguments.
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
classdef response_function
    properties
        descriptor='';
        respl     =[];
        probl     =[];
        rell      =[];
        grell     =[];
    end
    
    methods
        function [rf]=response_function(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if  (nargin == 1) && isa(varargin{1},'response_function')
                        rf=varargin{1};
                    else
                        rf.descriptor=varargin{1};

                        if (nargin >= 2)
                            rf.respl     =varargin{2};
                            if (nargin >= 3)
                                rf.probl     =varargin{3};
                                if (nargin >= 4)
                                    rf.rell      =varargin{4};
                                    if (nargin >= 5)
                                        rf.grell     =varargin{5};

                                        if (nargin > 5)
                                            warning('response_function:extra_arg',...
                                                'Extra arguments for object of class ''%s''.',...
                                                class(rf));
                                        end
                                    end
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(rf)
            desc=cell(size(rf));
            for i=1:numel(rf)
                desc(i)=cellstr(rf(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [stype] =prop_stype(rf)
            stype={};
        end
        function [scale] =prop_scale(rf)
            scale=[];
        end
        function [weight]=prop_weight(rf)
            weight=[];
        end
        function [lower] =prop_lower(rf)
            lower=[];
        end
        function [upper] =prop_upper(rf)
            upper=[];
        end
        function [target]=prop_target(rf)
            target=[];
        end
        function [respl,probl,rell,grell]=prop_levels(rf)
            respl=cell(size(rf));
            probl=cell(size(rf));
            rell =cell(size(rf));
            grell=cell(size(rf));
            for i=1:numel(rf)
                respl(i)={rf(i).respl};
                probl(i)={rf(i).probl};
                rell (i)={rf(i).rell};
                grell(i)={rf(i).grell};
            end
            respl=allempty(respl);
            probl=allempty(probl);
            rell =allempty(rell);
            grell=allempty(grell);
        end
    end
end
