%
%  display for the response_function class.
%
%  []=display(rf)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(rf)

if ~isa(rf,'response_function')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(rf),'response_function');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(rf)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(rf),inputname(1),string_dim(rf,i)));
    disp(sprintf('    descriptor: ''%s'''  ,rf(i).descriptor));
    disp(sprintf('         respl: %s'      ,string_vec(rf(i).respl)));
    disp(sprintf('         probl: %s'      ,string_vec(rf(i).probl)));
    disp(sprintf('          rell: %s'      ,string_vec(rf(i).rell)));
    disp(sprintf('         grell: %s\n'    ,string_vec(rf(i).grell)));
end

end
