%
%  display for the normal_uncertain class.
%
%  []=display(nuv)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(nuv)

if ~isa(nuv,'normal_uncertain')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(nuv),'normal_uncertain');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(nuv)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(nuv),inputname(1),string_dim(nuv,i)));
    disp(sprintf('    descriptor: ''%s'''  ,nuv(i).descriptor));
    disp(sprintf('          mean: %g'      ,nuv(i).mean));
    disp(sprintf('        stddev: %g'      ,nuv(i).stddev));
    disp(sprintf('         lower: %g'      ,nuv(i).lower));
    disp(sprintf('         upper: %g\n'    ,nuv(i).upper));
end

end
