%
%  display for the linear_inequality_constraint class.
%
%  []=display(lic)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(lic)

if ~isa(lic,'linear_inequality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(lic),'linear_inequality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(lic)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(lic),inputname(1),string_dim(lic,i)));
    disp(sprintf('        matrix: %s'      ,string_vec(lic(i).matrix)));
    disp(sprintf('         lower: %g'      ,lic(i).lower));
    disp(sprintf('         upper: %g'      ,lic(i).upper));
    disp(sprintf('    scale_type: ''%s'''  ,lic(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,lic(i).scale));
end

end

