%
%  display for the least_squares_term class.
%
%  []=display(lst)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(lst)

if ~isa(lst,'least_squares_term')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(lst),'least_squares_term');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(lst)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(lst),inputname(1),string_dim(lst,i)));
    disp(sprintf('    descriptor: ''%s'''  ,lst(i).descriptor));
    disp(sprintf('    scale_type: ''%s'''  ,lst(i).scale_type));
    disp(sprintf('         scale: %g'      ,lst(i).scale));
    disp(sprintf('        weight: %g\n'    ,lst(i).weight));
end

end
