%
%  display for the continuous_design class.
%
%  []=display(cdv)
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
function []=display(cdv)

if ~isa(cdv,'continuous_design')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(cdv),'continuous_design');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(cdv)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(cdv),inputname(1),string_dim(cdv,i)));
    disp(sprintf('    descriptor: ''%s'''  ,cdv(i).descriptor));
    disp(sprintf('        initpt: %g'      ,cdv(i).initpt));
    disp(sprintf('         lower: %g'      ,cdv(i).lower));
    disp(sprintf('         upper: %g'      ,cdv(i).upper));
    disp(sprintf('    scale_type: ''%s'''  ,cdv(i).scale_type));
    disp(sprintf('         scale: %g'      ,cdv(i).scale));
end

end
