%
%  definition for the continuous_design class.
%
%  [cdv]=continuous_design(varargin)
%
%  where the required varargin are:
%    descriptor    (char, description, '')
%    initpt        (double, initial point, 0.)
%  and the optional varargin and defaults are:
%    lower         (double, lower bound, -Inf)
%    upper         (double, upper bound,  Inf)
%    scale_type    (char, scaling type, 'none')
%    scale         (double, scaling factor, 1.)
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and two or more
%  arguments constructs a new instance from the arguments.
%
%  "Copyright 2009, by the California Institute of Technology.
%  ALL RIGHTS RESERVED. United States Government Sponsorship
%  acknowledged. Any commercial use must be negotiated with
%  the Office of Technology Transfer at the California Institute
%  of Technology.  (NTR 47078)
%
%  This software may be subject to U.S. export control laws.
%  By accepting this  software, the user agrees to comply with
%  all applicable U.S. export laws and regulations. User has the
%  responsibility to obtain export licenses, or other export
%  authority as may be required before exporting such information
%  to foreign countries or providing access to foreign persons."
%
classdef continuous_design
    properties
        descriptor='';
        initpt    = 0.;
        lower     =-Inf;
        upper     = Inf;
        scale_type='none';
        scale     = 1.;
    end
    
    methods
        function [cdv]=continuous_design(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'continuous_design')
                        cdv=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'continuous_design');
                    end

%  create the object from the input

                otherwise
                    cdv.descriptor=varargin{1};

                    if (nargin >= 2)
                        cdv.initpt    =varargin{2};
                        if (nargin >= 3)
                            cdv.lower     =varargin{3};
                            if (nargin >= 4)
                                cdv.upper     =varargin{4};
                                if (nargin >= 5)
                                    cdv.scale_type=varargin{5};
                                    if (nargin >= 6)
                                        cdv.scale     =varargin{6};
                                        if (nargin > 6)
                                            warning('continuous_design:extra_arg',...
                                                'Extra arguments for object of class ''%s''.',...
                                                class(cdv));
                                        end
                                    end
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(cdv)
            desc=cell(size(cdv));
            for i=1:numel(cdv)
                desc(i)=cellstr(cdv(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [initpt]=prop_initpt(cdv)
            initpt=zeros(size(cdv));
            for i=1:numel(cdv)
                initpt(i)=cdv(i).initpt;
            end
            initpt=allequal(initpt,0.);
        end
        function [lower] =prop_lower(cdv)
            lower=zeros(size(cdv));
            for i=1:numel(cdv)
                lower(i)=cdv(i).lower;
            end
            lower=allequal(lower,-Inf);
        end
        function [upper] =prop_upper(cdv)
            upper=zeros(size(cdv));
            for i=1:numel(cdv)
                upper(i)=cdv(i).upper;
            end
            upper=allequal(upper, Inf);
        end
        function [mean]  =prop_mean(cdv)
            mean=[];
        end
        function [stddev]=prop_stddev(cdv)
            stddev=[];
        end
        function [initst]=prop_initst(cdv)
            initst=[];
        end
        function [stype] =prop_stype(cdv)
            stype=cell(size(cdv));
            for i=1:numel(cdv)
                stype(i)=cellstr(cdv(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(cdv)
            scale=zeros(size(cdv));
            for i=1:numel(cdv)
                scale(i)=cdv(i).scale;
            end
            scale=allequal(scale,1.);
        end
    end
end
