dnl
dnl AC_PATH_PPM()
dnl
dnl Defines PPM_INCDIR and PPM_LIBDIR if they exist, and leaves them undefined
dnl otherwise.
dnl
dnl version 0.1    
dnl 3 May 2002
dnl David W. Pierce
dnl Climate Research Division
dnl Scripps Institution of Oceanography
dnl dpierce@ucsd.edu
dnl
dnl *******************************************************************************
dnl This code is in the public domain, and can be used for any purposes whatsoever. 
dnl *******************************************************************************
dnl 
dnl
AC_DEFUN([AC_PATH_PPM],[
AC_ARG_WITH( ppm_incdir, [  --with-ppm_incdir=dir directory containing ppm includes],  PPM_INCDIR=$withval)
dnl
dnl
dnl =================================================================================
dnl check for ppm include directory
dnl
err=0
if test x$PPM_INCDIR != x; then
        AC_CHECK_HEADER( $PPM_INCDIR/ppm.h,
          echo "Using user-specified ppm include dir=$PPM_INCDIR",
          err=1 )
fi
if test $err -eq 1; then
        echo "Error: user specified ppm include directory does not have ppm.h!"
        exit -1
fi
if test x$PPM_INCDIR = x; then
        AC_CHECK_HEADER( /usr/local/include/ppm.h, PPM_INCDIR=/usr/local/include )
fi
if test x$PPM_INCDIR = x; then
        AC_CHECK_HEADER( /usr/include/ppm.h, PPM_INCDIR=/usr/include )
fi
if test x$PPM_INCDIR = x; then
        AC_CHECK_HEADER( $HOME/include/ppm.h, PPM_INCDIR=$HOME/include )
fi
dnl
dnl =================================================================================
dnl check for ppm lib directory
dnl
PPM_LIBNAME=libppm.so
dnl
AC_ARG_WITH( ppm_libdir, [  --with-ppm_libdir=dir directory containing ppm library],  PPM_LIBDIR=$withval)
err=0
if test x$PPM_LIBDIR != x; then
        AC_CHECK_FILE( $PPM_LIBDIR/$PPM_LIBNAME,
          echo "Using user-specified ppm library dir=$PPM_LIBDIR",
          err=1 )
fi
if test $err -eq 1; then
        echo "Error: user specified ppm library directory does not have $PPM_LIBNAME !"
        exit -1
fi
if test x$PPM_LIBDIR = x; then
	AC_CHECK_LIB( ppm, ppm_writeppm, PPM_LIBDIR=. )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( /usr/local/lib/$PPM_LIBNAME, PPM_LIBDIR=/usr/local/lib )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( /usr/lib/$PPM_LIBNAME, PPM_LIBDIR=/usr/lib )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( /lib/$PPM_LIBNAME, PPM_LIBDIR=/lib )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( $HOME/lib/$PPM_LIBNAME, PPM_LIBDIR=$HOME/lib )
fi
dnl
dnl =================================================================================
dnl If ppm library not found, try netpbm
dnl
if test x$PPM_LIBDIR = x; then
PPM_LIBNAME=libnetpbm.so
if test x$PPM_LIBDIR = x; then
	AC_CHECK_LIB( netpbm, ppm_writeppm, PPM_LIBDIR=. )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( /usr/local/lib/$PPM_LIBNAME, PPM_LIBDIR=/usr/local/lib )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( /usr/lib/$PPM_LIBNAME, PPM_LIBDIR=/usr/lib )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( /lib/$PPM_LIBNAME, PPM_LIBDIR=/lib )
fi
if test x$PPM_LIBDIR = x; then
        AC_CHECK_FILE( $HOME/lib/$PPM_LIBNAME, PPM_LIBDIR=$HOME/lib )
fi
fi
dnl
dnl
PPM_LIBNAME=`echo $PPM_LIBNAME | sed s/lib// | sed s/\.so//`
dnl
dnl Export our variables
dnl
AC_SUBST(PPM_INCDIR)
AC_SUBST(PPM_LIBDIR)
AC_SUBST(PPM_LIBNAME)
dnl
])
