md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');
md.cluster=none;
md.spctemperature=[md.spctemperature, md.spctemperature+5, md.spctemperature+10, md.spctemperature+15; 1.5 2.5 3.5 4];
md.dt=1;
md.ndt=4;
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature1','BasalMeltingRate1','Temperature2','BasalMeltingRate2','Temperature3','BasalMeltingRate3','Temperature4','BasalMeltingRate4'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution(1).Temperature),...
	PatchToVec(md.results.ThermalSolution(1).BasalMeltingRate),...
	PatchToVec(md.results.ThermalSolution(2).Temperature),...
	PatchToVec(md.results.ThermalSolution(2).BasalMeltingRate),...
	PatchToVec(md.results.ThermalSolution(3).Temperature),...
	PatchToVec(md.results.ThermalSolution(3).BasalMeltingRate),...
	PatchToVec(md.results.ThermalSolution(4).Temperature),...
	PatchToVec(md.results.ThermalSolution(4).BasalMeltingRate),...
	};
